<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Job extends Model 
{

    protected $table = 'jobs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'name', 'status');
    protected $visible = array('slug', 'name', 'status');

    public function users()
    {
        return $this->hasMany('App\Models\User', 'job_id');
    }

}